"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var html_node_1 = require("./html-node");
/**
 * @class Autolinker.htmlParser.ElementNode
 * @extends Autolinker.htmlParser.HtmlNode
 *
 * Represents an HTML element node that has been parsed by the {@link Autolinker.htmlParser.HtmlParser}.
 *
 * See this class's superclass ({@link Autolinker.htmlParser.HtmlNode}) for more
 * details.
 */
var ElementNode = /** @class */ (function (_super) {
    tslib_1.__extends(ElementNode, _super);
    /**
     * @method constructor
     * @param {Object} cfg The configuration options for this class, specified
     *   in an Object.
     */
    function ElementNode(cfg) {
        var _this = _super.call(this, cfg) || this;
        /**
         * @cfg {String} tagName (required)
         *
         * The name of the tag that was matched.
         */
        _this.tagName = ''; // default value just to get the above doc comment in the ES5 output and documentation generator
        /**
         * @cfg {Boolean} closing (required)
         *
         * `true` if the element (tag) is a closing tag, `false` if its an opening
         * tag.
         */
        _this.closing = false; // default value just to get the above doc comment in the ES5 output and documentation generator
        _this.tagName = cfg.tagName;
        _this.closing = cfg.closing;
        return _this;
    }
    /**
     * Returns a string name for the type of node that this class represents.
     *
     * @return {String}
     */
    ElementNode.prototype.getType = function () {
        return 'element';
    };
    /**
     * Returns the HTML element's (tag's) name. Ex: for an &lt;img&gt; tag,
     * returns "img".
     *
     * @return {String}
     */
    ElementNode.prototype.getTagName = function () {
        return this.tagName;
    };
    /**
     * Determines if the HTML element (tag) is a closing tag. Ex: &lt;div&gt;
     * returns `false`, while &lt;/div&gt; returns `true`.
     *
     * @return {Boolean}
     */
    ElementNode.prototype.isClosing = function () {
        return this.closing;
    };
    return ElementNode;
}(html_node_1.HtmlNode));
exports.ElementNode = ElementNode;

//# sourceMappingURL=element-node.js.map
